//+------------------------------------------------------------------+
//|                                       ClusterDelta MFI indicator |
//|                                           Copyright  ظ 2012 |
//|                                           http://clusterdelta.com|
//+------------------------------------------------------------------+
//---- indicator settings
#property copyright " ظ 2012"               // modification_14.04.2012 Anry
#property link      "http://clusterdelta.com"
#property  indicator_separate_window
#property indicator_minimum 0
#property indicator_buffers 5
#property indicator_color1  Black
#property indicator_color2  LimeGreen
#property indicator_color3  Maroon
#property indicator_color4  DarkOliveGreen
#property indicator_color5  Red
#property indicator_width2  3
#property indicator_width3  3
#property indicator_width4  3
#property indicator_width5  3
//---- indicator buffers
double ExtMFIBuffer[];
double ExtMFIUpVUpBuffer[];
double ExtMFIDownVDownBuffer[];
double ExtMFIUpVDownBuffer[];
double ExtMFIDownVUpBuffer[];
extern string Instrument="AUTO";
extern int  Update_in_sec=14;
extern string Meta_Trader_GMT="AUTO";

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicator buffers mapping
   SetIndexBuffer(0,ExtMFIBuffer);       
   SetIndexBuffer(1,ExtMFIUpVUpBuffer);
   SetIndexBuffer(2,ExtMFIDownVDownBuffer);
   SetIndexBuffer(3,ExtMFIUpVDownBuffer);
   SetIndexBuffer(4,ExtMFIDownVUpBuffer);
//---- drawing settings
   SetIndexStyle(0,DRAW_NONE);
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1,159);
   SetIndexStyle(2,DRAW_ARROW);
   SetIndexArrow(2,159);
   SetIndexStyle(3,DRAW_ARROW);
   SetIndexArrow(3,159);
   SetIndexStyle(4,DRAW_ARROW);
   SetIndexArrow(4,159);
//---- name for DataWindow and indicator subwindow label
   IndicatorShortName("ClusterDelta MFI  http://clusterdelta.com");
   SetIndexLabel(0,"ClusterDelta MFI  http://clusterdelta.com");      
   SetIndexLabel(1,"ClusterDelta MFI  http://clusterdelta.com");
   SetIndexLabel(2,"ClusterDelta MFI  http://clusterdelta.com");
   SetIndexLabel(3,"ClusterDelta MFI  http://clusterdelta.com");
   SetIndexLabel(4,"ClusterDelta MFI  http://clusterdelta.com");
//---- sets drawing line empty value
   SetIndexEmptyValue(0, 0.0);
   SetIndexEmptyValue(1, 0.0);
   SetIndexEmptyValue(2, 0.0);       
   SetIndexEmptyValue(3, 0.0);
   SetIndexEmptyValue(4, 0.0);      
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| BW Market Facilitation Index                                     |
//+------------------------------------------------------------------+
int start()
  {
   int  i,nLimit,nCountedBars;
   bool bMfiUp=true,bVolUp=true;
//---- bars count that does not changed after last indicator launch.
   nCountedBars=IndicatorCounted();
//---- last counted bar will be recounted
   if(nCountedBars>0) nCountedBars--;
   nLimit=Bars-nCountedBars;
//---- Market Facilitation Index calculation
   for(i=0; i<nLimit; i++)
     {
      if(CompareDouble(iCustom(Symbol(),0,"ClusterDelta_Volume","_ _",Instrument,Update_in_sec,Meta_Trader_GMT,false,"vt>=500",0,i),0.0))
        {
         Print(iCustom(Symbol(),0,"ClusterDelta_Volume","_ _",Instrument,Update_in_sec,Meta_Trader_GMT,false,"vt>=500",0,i));
         if(i==Bars-1) ExtMFIBuffer[i]=0.0;
         else ExtMFIBuffer[i]=ExtMFIBuffer[i+1];
        }
      else ExtMFIBuffer[i]=(High[i]-Low[i])/(iCustom(Symbol(),0,"ClusterDelta_Volume","_ _",Instrument,Update_in_sec,Meta_Trader_GMT,false,"vt>=500",0,i)*Point);
     }
//---- upanddown flags setting
   if(nCountedBars>1)
     {
      //---- analyze previous bar before recounted bar
      i=nLimit+1;
      if(ExtMFIUpVUpBuffer[i]!=0.0)
        {
         bMfiUp=true;
         bVolUp=true;
        }
      if(ExtMFIDownVDownBuffer[i]!=0.0)
        {
         bMfiUp=false;
         bVolUp=false;
        }
      if(ExtMFIUpVDownBuffer[i]!=0.0)
        {
         bMfiUp=true;
         bVolUp=false;
        }
      if(ExtMFIDownVUpBuffer[i]!=0.0)
        {
         bMfiUp=false;
         bVolUp=true;
        }
     }
//---- dispatch values between 4 buffers
   for(i=nLimit-1; i>=0; i--)
     {
      if(i<Bars-1)
        {
         if(ExtMFIBuffer[i]>ExtMFIBuffer[i+1]) bMfiUp=true;
         if(ExtMFIBuffer[i]<ExtMFIBuffer[i+1]) bMfiUp=false;
         if(iCustom(Symbol(),0,"ClusterDelta_Volume","_ _",Instrument,Update_in_sec,Meta_Trader_GMT,false,"vt>=500",0,i)>iCustom(Symbol(),0,"ClusterDelta_Volume","_ _",Instrument,Update_in_sec,Meta_Trader_GMT,false,"vt>=500",0,i+1))             bVolUp=true;
         if(iCustom(Symbol(),0,"ClusterDelta_Volume","_ _",Instrument,Update_in_sec,Meta_Trader_GMT,false,"vt>=500",0,i)<iCustom(Symbol(),0,"ClusterDelta_Volume","_ _",Instrument,Update_in_sec,Meta_Trader_GMT,false,"vt>=500",0,i+1))             bVolUp=false;
        }
     if(bMfiUp && bVolUp)
       {
        ExtMFIUpVUpBuffer[i]=WindowPriceMax();
        ExtMFIDownVDownBuffer[i]=0.0;
        ExtMFIUpVDownBuffer[i]=0.0;
        ExtMFIDownVUpBuffer[i]=0.0;
        continue;
       }
     if(!bMfiUp && !bVolUp)
       {
        ExtMFIUpVUpBuffer[i]=0.0;
        ExtMFIDownVDownBuffer[i]=WindowPriceMax();
        ExtMFIUpVDownBuffer[i]=0.0;
        ExtMFIDownVUpBuffer[i]=0.0;
        continue;         
       }
     if(bMfiUp && !bVolUp)
       {
        ExtMFIUpVUpBuffer[i]=0.0;
        ExtMFIDownVDownBuffer[i]=0.0;
        ExtMFIUpVDownBuffer[i]=WindowPriceMax();
        ExtMFIDownVUpBuffer[i]=0.0;
        continue;         
       }
     if(!bMfiUp && bVolUp)
       {
        ExtMFIUpVUpBuffer[i]=0.0;
        ExtMFIDownVDownBuffer[i]=0.0;
        ExtMFIUpVDownBuffer[i]=0.0;
        ExtMFIDownVUpBuffer[i]=WindowPriceMax();
        continue;         
       }        
    }                     
//---- done
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool CompareDouble(double dNumber1, double dNumber2)
  {
   bool bCompare=NormalizeDouble(dNumber1-dNumber2,8) == 0;
   return(bCompare);
  }
//+------------------------------------------------------------------+